/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.ElephantEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ElephantModel<T extends ElephantEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Tusks;
    private final ModelPart Body;
    private final ModelPart Chests;
    private final ModelPart Saddle;
    private final ModelPart Head;
    private final ModelPart TrunkTop;
    private final ModelPart TrunkMiddle;
    private final ModelPart TrunkBottom;
    private final ModelPart RightFrontLeg;
    private final ModelPart LeftFrontLeg;
    private final ModelPart RightBackLeg;
    private final ModelPart LeftBackLeg;
    private final ModelPart LeftEar;
    private final ModelPart RightEar;
    private float headAngle;

    public ElephantModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Chests = this.Body.m_171324_("Chests");
        this.Saddle = this.Body.m_171324_("Saddle");
        this.Head = this.Body.m_171324_("Head");
        this.LeftEar = this.Head.m_171324_("LeftEar");
        this.RightEar = this.Head.m_171324_("RightEar");
        this.Tusks = this.Head.m_171324_("Tusks");
        this.TrunkTop = this.Head.m_171324_("TrunkTop");
        this.TrunkMiddle = this.TrunkTop.m_171324_("TrunkMiddle");
        this.TrunkBottom = this.TrunkMiddle.m_171324_("TrunkBottom");
        this.RightFrontLeg = this.Body.m_171324_("RightFrontLeg");
        this.LeftFrontLeg = this.Body.m_171324_("LeftFrontLeg");
        this.RightBackLeg = this.Body.m_171324_("RightBackLeg");
        this.LeftBackLeg = this.Body.m_171324_("LeftBackLeg");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        }
        this.Body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(ElephantEntity elephant, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104203_ = elephant.getAttackTimer() > 0 ? this.headAngle : -0.0436332f + headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.walk(this.RightFrontLeg, this.LeftFrontLeg, this.RightBackLeg, this.LeftBackLeg, limbSwing, limbSwingAmount);
        if (elephant.m_21660_()) {
            this.LeftEar.f_104204_ = 1.13446f;
            this.LeftEar.f_104205_ = 0.1309f;
            this.RightEar.f_104204_ = -1.13446f;
            this.RightEar.f_104205_ = -0.1309f;
        } else {
            this.LeftEar.f_104204_ = 0.4799655f + 0.3f * Mth.m_14031_((float)(0.1f * ageInTicks + 1.0f + (float)Math.PI));
            this.LeftEar.f_104205_ = 0.0f;
            this.RightEar.f_104204_ = -0.4799655f + 0.3f * Mth.m_14031_((float)(0.1f * ageInTicks + 1.0f));
            this.RightEar.f_104205_ = 0.0f;
        }
        this.TrunkTop.f_104203_ = 0.0436332f + 0.1f * Mth.m_14031_((float)(0.1f * ageInTicks + 1.0f));
        this.TrunkTop.f_104205_ = 0.1f * Mth.m_14031_((float)(0.1f * ageInTicks + 1.0f));
        this.TrunkMiddle.f_104203_ = 0.0436332f + 0.15f * Mth.m_14089_((float)(0.1f * ageInTicks + 2.0f));
        this.TrunkMiddle.f_104205_ = 0.15f * Mth.m_14089_((float)(0.1f * ageInTicks + 2.0f));
        this.TrunkBottom.f_104203_ = 0.0872665f + 0.2f * Mth.m_14031_((float)(0.1f * ageInTicks + 2.0f));
        this.TrunkBottom.f_104205_ = 0.2f * Mth.m_14031_((float)(0.1f * ageInTicks + 2.0f));
    }

    public void prepareMobModel(ElephantEntity elephant, float limbSwing, float limbSwingAmount, float partialTick) {
        float i = elephant.getAttackTimer();
        if (i > 0.0f) {
            float progress = 1.0f - (i - partialTick) / 10.0f;
            this.headAngle = Mth.m_14179_((float)progress, (float)0.174533f, (float)-0.959931f);
        }
        this.Chests.f_104207_ = elephant.hasChest();
        this.Saddle.f_104207_ = elephant.isSaddled();
        this.Tusks.f_104207_ = !this.f_102610_;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 65).m_171488_(-11.0f, -41.0f, -20.0f, 22.0f, 23.0f, 40.0f, new CubeDeformation(0.0f)).m_171514_(156, 93).m_171488_(-8.0f, -42.0f, -17.0f, 16.0f, 1.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)25.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(123, 45).m_171488_(-9.0f, -9.0f, -12.0f, 18.0f, 16.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-35.0f, (float)-20.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition TrunkTop = Head.m_171599_("TrunkTop", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -0.1f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)-8.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition TrunkMiddle = TrunkTop.m_171599_("TrunkMiddle", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-3.0f, -0.2f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition TrunkBottom = TrunkMiddle.m_171599_("TrunkBottom", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-2.0f, 0.7f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_().m_171514_(220, 37).m_171480_().m_171488_(0.0f, -8.0f, 0.0f, 1.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)9.0f, (float)-1.0f, (float)-6.0f, (float)0.1309f, (float)0.48f, (float)0.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_().m_171514_(200, 37).m_171488_(-1.0f, -8.0f, 0.0f, 1.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.0f, (float)-1.0f, (float)-6.0f, (float)0.1309f, (float)-0.48f, (float)0.0f));
        PartDefinition Tusks = Head.m_171599_("Tusks", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightTusk = Tusks.m_171599_("RightTusk", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)6.0f, (float)-9.0f));
        PartDefinition RightTuskTop = RightTusk.m_171599_("RightTuskTop", CubeListBuilder.m_171558_().m_171514_(192, 0).m_171488_(-15.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)14.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightTuskMiddle = RightTuskTop.m_171599_("RightTuskMiddle", CubeListBuilder.m_171558_().m_171514_(204, 0).m_171480_().m_171488_(-15.0f, -0.35f, -1.05f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.001f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition RightTuskBottom = RightTuskMiddle.m_171599_("RightTuskBottom", CubeListBuilder.m_171558_().m_171514_(215, 0).m_171488_(-15.0f, -0.85f, -1.475f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.002f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTusk = Tusks.m_171599_("LeftTusk", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.0f, (float)6.0f, (float)-9.0f));
        PartDefinition LeftTuskTop = LeftTusk.m_171599_("LeftTuskTop", CubeListBuilder.m_171558_().m_171514_(192, 0).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTuskMiddle = LeftTuskTop.m_171599_("LeftTuskMiddle", CubeListBuilder.m_171558_().m_171514_(204, 0).m_171488_(-1.0f, -0.35f, -1.05f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTuskBottom = LeftTuskMiddle.m_171599_("LeftTuskBottom", CubeListBuilder.m_171558_().m_171514_(215, 0).m_171480_().m_171488_(-1.0f, -0.85f, -1.475f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.002f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition RightFrontLeg = Body.m_171599_("RightFrontLeg", CubeListBuilder.m_171558_().m_171514_(95, 0).m_171488_(-2.75f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-8.0f, (float)-19.0f, (float)-16.0f));
        PartDefinition LeftFrontLeg = Body.m_171599_("LeftFrontLeg", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171488_(-3.25f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-19.0f, (float)-16.0f));
        PartDefinition LeftBackLeg = Body.m_171599_("LeftBackLeg", CubeListBuilder.m_171558_().m_171514_(122, 0).m_171488_(-3.25f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-19.0f, (float)16.0f));
        PartDefinition RightBackLeg = Body.m_171599_("RightBackLeg", CubeListBuilder.m_171558_().m_171514_(149, 0).m_171488_(-2.75f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-8.0f, (float)-19.0f, (float)16.0f));
        PartDefinition Chests = Body.m_171599_("Chests", CubeListBuilder.m_171558_().m_171514_(54, 38).m_171488_(11.0f, -36.0f, 9.5f, 2.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(54, 38).m_171480_().m_171488_(-13.0f, -36.0f, 9.5f, 2.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(127, 112).m_171480_().m_171488_(10.2f, -41.475f, 11.5f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(127, 112).m_171488_(-11.2f, -41.475f, 11.5f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(127, 105).m_171488_(-8.5f, -42.475f, 11.5f, 17.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition HolderLeft = Chests.m_171599_("HolderLeft", CubeListBuilder.m_171558_().m_171514_(173, 104).m_171488_(-1.158f, 0.4397f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)9.6f, (float)-42.5f, (float)13.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition HolderRight = Chests.m_171599_("HolderRight", CubeListBuilder.m_171558_().m_171514_(173, 104).m_171488_(-1.842f, 0.4397f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)-9.6f, (float)-42.5f, (float)13.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition Saddle = Body.m_171599_("Saddle", CubeListBuilder.m_171558_().m_171514_(127, 112).m_171488_(-6.5f, -43.0f, -7.0f, 13.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(128, 100).m_171488_(-6.0f, -44.0f, 3.0f, 12.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(181, 113).m_171488_(-11.2f, -41.475f, -2.0f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(181, 113).m_171480_().m_171488_(10.2f, -41.475f, -2.0f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(168, 117).m_171488_(-1.5f, -45.0f, -7.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(245, 43).m_171488_(10.4f, -31.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(245, 43).m_171488_(-11.4f, -31.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(245, 43).m_171488_(10.375f, -31.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(245, 43).m_171488_(-11.375f, -31.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition SaddleRight = Saddle.m_171599_("SaddleRight", CubeListBuilder.m_171558_().m_171514_(158, 100).m_171488_(-2.8499f, 0.8811f, -0.5f, 5.0f, 1.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)-8.625f, (float)-43.175f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition SaddleLeft = Saddle.m_171599_("SaddleLeft", CubeListBuilder.m_171558_().m_171514_(158, 100).m_171480_().m_171488_(-2.2485f, 0.8811f, -0.5f, 5.0f, 1.0f, 2.0f, new CubeDeformation(-0.001f)).m_171555_(false), PartPose.m_171423_((float)8.725f, (float)-43.15f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.3054f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)128);
    }
}

